package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.algo;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.model.matching.merge.algo.merge.MergeAlgorithm;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.model.soup.edge.weight.EdgeInfoProvider;
import ru.yandex.crypta.graph2.model.soup.edge.weight.EdgeScore;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;

import static ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.algo.TryMergeByEdge.FAIL_INIT;

public class TryMergeByVertex implements TryMerge<Vertex> {

    private EdgeInfoProvider edgeInfoProvider;
    private MergeAlgorithm mergeStrategy;

    public TryMergeByVertex(EdgeInfoProvider edgeInfoProvider,
                            MergeAlgorithm mergeStrategy) {
        this.edgeInfoProvider = edgeInfoProvider;
        this.mergeStrategy = mergeStrategy;
    }

    @Override
    public MergeOffers suggestMergeOffers(MergeKey mergeKey, GraphInfo graphInfo, Vertex joinVertex) {

        MapF<String, EdgeScore> linkScore = getComponentsLinkScore(graphInfo.getComponents(), joinVertex);
        ListF<String> componentsMergePriority = linkScore.entries()
                .sortedBy2(EdgeScore.COMPARATOR).reverse()
                .get1();


        MergeOffers result = new MergeOffers();

        String mainCryptaId = componentsMergePriority.first();
        Component mainComponent = graphInfo.components.getTs(mainCryptaId);


        for (String cryptaId : componentsMergePriority.drop(1)) {
            Component component = graphInfo.components.getTs(cryptaId);

            MergeOffer mergeOffer = mergeStrategy.merge(mergeKey, mainComponent, component, graphInfo, Cf.list());

            if (FAIL_INIT.containsTs(mergeOffer.getStatus())) {
                result.addOFailedOffer(mergeOffer);
            } else {
                result.addOkOffer(mergeOffer);
            }
        }

        return result;

    }

    private MapF<String, EdgeScore> getComponentsLinkScore(CollectionF<Component> components, Vertex joinVertex) {
        MapF<String, SetF<Edge>> joiningEdges = components
                .toMap(Component::getCryptaId, Component::getInnerEdges)
                .mapValues(edges -> edges.filter(
                        e -> e.getVertices().containsTs(joinVertex)
                ));

        return joiningEdges.mapValues(edgeInfoProvider::getMultiEdgeScore);

    }

}
