package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.helper;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.dao.yt.bendable.YsonMultiEntitySupport;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.edge.EdgeInComponent;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.model.matching.vertex.VertexInComponent;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.graph2.utils.IteratorUtils;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

/**
 * TODO: This class is stupid: fix inheritance, fix indexes usage
 */
public class GraphInfoRecsParser implements YtSerializable {


    public static final int VERTICES_IN_INDEX = 0;
    public static final int VERTICES_PROPERTIES_IN_INDEX = 1;
    public static final int EDGES_IN_INDEX = 2;

    public static final int MERGE_OFFERS_INDEX = 3;
    public static final int EDGES_BETWEEN_INDEX = 4;

    private YsonMultiEntitySupport recsHelper;
    private int oomIndex;
    private int strangeIndex;
    private int recsLimit;

    public GraphInfoRecsParser(YsonMultiEntitySupport recsHelper, int oomIndex, int strangeIndex, int recsLimit) {
        this.recsHelper = recsHelper;
        this.oomIndex = oomIndex;
        this.strangeIndex = strangeIndex;
        this.recsLimit = recsLimit;
    }

    private Option<IteratorUtils.IteratorSplit<YTreeMapNode>> checkOverlimit(IteratorF<YTreeMapNode> recsRaw, Yield<YTreeMapNode> yield) {
        var componentRecsAndOther = IteratorUtils.takeWhileWithLimit(recsRaw,
                rec -> {return recsHelper.getTableIndex(rec) <= 3;}, recsLimit);
        if (componentRecsAndOther.isLimitReached()) {
            componentRecsAndOther.getHead().iterator().plus(componentRecsAndOther.getTail()).forEachRemaining(
                    r -> {
                        recsHelper.resetTableIndex(r);
                        yield.yield(oomIndex, r);
                    });
            return Option.empty();
        }
        return Option.of(componentRecsAndOther);
    }

    public Option<GraphInfo> parseInput(IteratorF<YTreeMapNode> rawRecs, Yield<YTreeMapNode> yield) {
        var records0 =  checkOverlimit(rawRecs, yield);
        if (!records0.isPresent()) {
            return Option.empty();
        }
        var recs = records0.get().getHead();

        if (recs.isEmpty()) {
            return Option.empty();
        }

        GraphInfo result = new GraphInfo();
        result.restRecords = Option.of(records0.get().getTail());

        for (YTreeMapNode rec : recs) {
            int tableIndex = recsHelper.getTableIndex(rec);
            if (tableIndex == VERTICES_IN_INDEX) {
                VertexInComponent v = recsHelper.parse(rec, VertexInComponent.class);

                String cryptaId = v.getCryptaId();
                Component component = result.components.computeIfAbsent(cryptaId, Component::new);

                component.addVertex(v.getVertex());


            } else if (tableIndex == VERTICES_PROPERTIES_IN_INDEX) {
                result.verticesProperties.accept(rec);
            } else if (tableIndex == EDGES_IN_INDEX) {
                EdgeInComponent edgeInComponent = recsHelper.parse(rec, EdgeInComponent.class);

                String cryptaId = edgeInComponent.getCryptaId();
                Component component = result.components.computeIfAbsent(cryptaId, Component::new);

                Edge edge = edgeInComponent.getEdge();
                edge.computeVertices();
                if (!edge.getVertex1().equals(edge.getVertex2())) {
                    component.addInnerEdge(edge);
                }

            } else if (tableIndex == MERGE_OFFERS_INDEX) {
                result.neighbourMergeOffers.add(recsHelper.parse(rec, MergeOffer.class));
            }
        }

        // TODO: reverse index is useless for components reducer
        for (Component component : result.components.values()) {
            for (Vertex vertex : component.getVertices()) {
                result.vertexToComponents.put(vertex, component);
            }
        }

        if (result.components.isEmpty()) {
            for (MergeOffer mergeOffer : result.neighbourMergeOffers) {
                yield.yield(strangeIndex, recsHelper.serialize(mergeOffer));
            }
            return Option.empty();
        }

        return Option.of(result);
    }
}
