package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.helper;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.crypta.graph2.matching.human.proto.UseMergeStrategyReducerInRec;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.proto.ComponentToMerge;
import ru.yandex.crypta.graph2.model.matching.score.MetricsTree;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;

public class GraphInfoRecsParserNew implements YtSerializable {

    public GraphInfo parseInput(IteratorF<UseMergeStrategyReducerInRec> recs) {

        GraphInfo result = new GraphInfo();

        recs.forEachRemaining(rec -> {
            if (rec.hasComponentToMergeRec1()) {
                ComponentToMerge mergeRec = rec.getComponentToMergeRec1();
                String cryptaId = mergeRec.getCryptaId();

                Component component = new Component(cryptaId);
                component.setGraphEngine(mergeRec.getGraphEngine());
                component.setScoreTree(MetricsTree.buildFromTStats(mergeRec.getStats()));
                component.setNeighboursCount(mergeRec.getNeighboursCount());
                component.setNeighboursWeight(mergeRec.getNeighboursWeight());

                result.components.put(cryptaId, component);

            } else if (rec.hasEdgeBetweenComponentsRec2()) {
                result.edgesBetweenComponents.add(new Edge(rec.getEdgeBetweenComponentsRec2()));
            } else {
                throw new IllegalArgumentException("Rec type is not supported " + rec);
            }
        });

        return result;
    }

}
