package ru.yandex.crypta.graph2.matching.human.workflow.merge_apply.ops;

import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.dao.yt.bendable.YsonMultiEntityReducerWithKey;
import ru.yandex.crypta.graph2.model.matching.component.ComponentCenter;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKeyWithNewCryptaIds;
import ru.yandex.crypta.graph2.model.matching.merge.MergeNeighbour;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.utils.IteratorUtils;
import ru.yandex.crypta.graph2.utils.IteratorUtils.IteratorSplit;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.misc.lang.Check;


public class AddChangedCryptaIdReducer extends YsonMultiEntityReducerWithKey<String> {

    @Override
    public String key(YTreeMapNode entry) {
        return entry.getString(ComponentCenter.CRYPTA_ID_COLUMN);
    }

    @Override
    public void reduce(String cryptaId, IteratorF<YTreeMapNode> entries, Yield<YTreeMapNode> yield,
            Statistics statistics) {

        IteratorSplit<YTreeMapNode> decisionAndComponentRecs = IteratorUtils.takeWhile(entries,
                rec -> getTableIndex(rec) == 0
        );

        ListF<MergeOffer> decisions = parse(decisionAndComponentRecs.getHead(), MergeOffer.class).toList();
        ListF<MergeNeighbour> recs = parse(decisionAndComponentRecs.getTail(), MergeNeighbour.class).toList();

        ListF<String> suggestedCryptaIds = decisions.map(MergeOffer::getToCryptaId);
        Check.isTrue(suggestedCryptaIds.size() <= 1, decisions.mkString("\n"));
        String finalCryptaId = suggestedCryptaIds.firstO().getOrElse(cryptaId);

        Set<MergeKey> mergeKeysOfCryptaId = recs
                .stream()
                .map(MergeNeighbour::getNeighbourKey)
                .collect(Collectors.toUnmodifiableSet());

        for (MergeKey mergeKey : mergeKeysOfCryptaId) {
            var mergeKeyWithCryptaId = new MergeKeyWithNewCryptaIds(mergeKey, cryptaId);
            mergeKeyWithCryptaId.updateFromTo(cryptaId, finalCryptaId);

            yield.yield(serialize(mergeKeyWithCryptaId));
        }
    }

}

