package ru.yandex.crypta.graph2.matching.human.workflow.merge_apply.ops;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.dao.yt.bendable.YsonMultiEntityReducerWithKey;
import ru.yandex.crypta.graph2.model.matching.component.ComponentCenter;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.utils.IteratorUtils;
import ru.yandex.crypta.graph2.utils.IteratorUtils.IteratorSplit;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.misc.lang.Check;


public class ApplyMergeDecisionReducer extends YsonMultiEntityReducerWithKey<String> {

    @Override
    public String key(YTreeMapNode entry) {
        return entry.getString(ComponentCenter.CRYPTA_ID_COLUMN);
    }


    @Override
    public void reduce(String componentCenter, IteratorF<YTreeMapNode> entries, Yield<YTreeMapNode> yield,
                       Statistics statistics) {
        IteratorSplit<YTreeMapNode> decisionAndComponentRecs = IteratorUtils.takeWhile(entries,
                rec -> getTableIndex(rec) == 0);

        ListF<MergeOffer> decisions = parse(decisionAndComponentRecs.getHead(), MergeOffer.class).toList();
        ListF<YTreeMapNode> componentRecs = decisionAndComponentRecs.getTail().toList();

        ListF<String> suggestedCryptaIds = decisions.map(MergeOffer::getToCryptaId);
        Check.isTrue(suggestedCryptaIds.size() <= 1, decisions.mkString("\n"));
        Option<String> finalCryptaId = suggestedCryptaIds.firstO();

        for (YTreeMapNode rec : componentRecs) {
            if (finalCryptaId.isPresent()) {
                rec.put(ComponentCenter.CRYPTA_ID_COLUMN, YTree.stringNode(finalCryptaId.get()));
            }
            yieldOriginalRec(yield, rec);
        }


    }

    private void yieldOriginalRec(Yield<YTreeMapNode> yield, YTreeMapNode rec) {
        int tableIndex = getTableIndex(rec);
        resetTableIndex(rec);
        yield.yield(tableIndex - 1, rec);  // first index were taken by merge offers
    }
}
