package ru.yandex.crypta.graph2.matching.human.workflow.merge_apply.ops;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.dao.yt.YtConfig;
import ru.yandex.crypta.graph2.dao.yt.YtCypressHelper;
import ru.yandex.crypta.graph2.dao.yt.local.LocalModeYt;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class ApplyMergeDecisionReducerLocalRun {

    public static void main(String[] args) {
        Yt yt = YtConfig.getYt();
        LocalModeYt localModeYt = new LocalModeYt(yt);

        String cryptaId = "7902860289524369744";
        var reducer = new ApplyMergeDecisionReducer();

        YPath decisions = YPath.simple("//home/crypta/team/atanna/merge_decisions");
        YPath vertices = YPath.simple("//home/crypta/production/state/graph/v2/matching/workdir/prepare/vertices_with_neighbours");
        YPath vp = YPath.simple("//home/crypta/production/state/graph/v2/matching/workdir/prepare/vertices_properties_with_neighbours");
        YPath edges = YPath.simple("//home/crypta/production/state/graph/v2/matching/workdir/prepare/edges_with_neighbours");

        ListF<YPath> rangedTables = Cf.list(decisions, vertices, vp, edges).map(t -> YtCypressHelper.mkRangeByKey(t, cryptaId));
        localModeYt.reduce(reducer, rangedTables);

    }
}
