package ru.yandex.crypta.graph2.matching.human.workflow.merge_apply.ops;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.dao.yt.bendable.YsonMultiEntityReducerWithKey;
import ru.yandex.crypta.graph2.model.matching.edge.EdgeBetweenComponents;
import ru.yandex.crypta.graph2.model.matching.edge.EdgeBetweenWithNewCryptaIds;
import ru.yandex.crypta.graph2.model.matching.edge.EdgeInComponent;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKeyWithNewCryptaIds;
import ru.yandex.crypta.graph2.utils.IteratorUtils;
import ru.yandex.crypta.graph2.utils.IteratorUtils.IteratorSplit;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;


public class ApplyMergeDecisionToEdgesBetweenReducer extends YsonMultiEntityReducerWithKey<MergeKey> {

    public static final int EDGES_MERGED_OUT_INDEX = 0;
    public static final int EDGES_NOT_MERGED_OUT_INDEX = 1;

    @Override
    public MergeKey key(YTreeMapNode entry) {
        return parse(entry, MergeKey.class);
    }

    @Override
    public void reduce(MergeKey mergeKey, IteratorF<YTreeMapNode> entries, Yield<YTreeMapNode> yield,
            Statistics statistics) {
        IteratorSplit<YTreeMapNode> decisionAndComponentRecs = IteratorUtils.takeWhile(entries,
                rec -> getTableIndex(rec) == 0);

        ListF<MergeKeyWithNewCryptaIds> mergeKeys = parse(decisionAndComponentRecs.getHead(), MergeKeyWithNewCryptaIds.class).toList();
        MergeKeyWithNewCryptaIds mergeKeyMain =
                new MergeKeyWithNewCryptaIds(mergeKey, null)
                        .updateWithOtherMergeKeys(mergeKeys);

        ListF<EdgeBetweenComponents> edgesRecs = parse(decisionAndComponentRecs.getTail(),
                EdgeBetweenComponents.class).toList();

        String leftCryptaId = mergeKeyMain.getNewLeftCryptaId();
        String rightCryptaId = mergeKeyMain.getNewRightCryptaId();

        if (leftCryptaId.equals(rightCryptaId)) {
            for (EdgeBetweenComponents rec : edgesRecs) {
                // edges between components became edges in component
                EdgeInComponent edgeInComponent = EdgeInComponent.fromEdge(rec.getEdge(), leftCryptaId);
                yield.yield(EDGES_MERGED_OUT_INDEX, serialize(edgeInComponent));
            }
        } else {
            for (EdgeBetweenComponents edge : edgesRecs) {
                EdgeBetweenWithNewCryptaIds out = new EdgeBetweenWithNewCryptaIds(
                        edge,
                        mergeKeyMain
                );

                out.setCryptaId(leftCryptaId);
                yield.yield(EDGES_NOT_MERGED_OUT_INDEX, serialize(out));
                out.setCryptaId(rightCryptaId);
                yield.yield(EDGES_NOT_MERGED_OUT_INDEX, serialize(out));
            }
        }
    }
}
