package ru.yandex.crypta.graph2.matching.human.workflow.merge_apply.ops;

import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.crypta.graph2.dao.yql.Yql;
import ru.yandex.crypta.graph2.dao.yql.YqlConfig;
import ru.yandex.crypta.graph2.dao.yt.YtConfig;
import ru.yandex.crypta.graph2.dao.yt.ops.YtOpsParams;
import ru.yandex.crypta.graph2.matching.human.workflow.merge_apply.ApplyMergeTask;
import ru.yandex.crypta.graph2.utils.NativeLibHelper;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.CypressNodeType;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class ApplyMergeDecisionToEdgesBetweenTestRun {

    public static void main(String[] args) {
        testRun();
    }

    public static void testRun() {
        NativeLibHelper.setLocalJavaLibraryPath();
        Yt yt = YtConfig.getYt(true);
        Yql yql = YqlConfig.getYql();

        Dao dao = new Dao(yt, yql, new YtOpsParams(null, 30000, null));

        YPath decisions = YPath.simple("//home/crypta/production/state/graph/v2/matching/workdir/merge/merge_decisions_confirmed");
        YPath mergeNeighbours = YPath.simple("//home/crypta/production/state/graph/v2/matching/workdir/init/merge_neighbours");
        YPath edgesBetween = YPath.simple("//home/crypta/production/state/graph/v2/matching/workdir/init/soup_edges_between_components_by_merge_key");

        YPath workdir = YPath.simple("//home/crypta/team/atanna/mathcing_merge_apply_new");
        YPath tmpDecisions = workdir.child("decisions");
        YPath tmpMergeNeighbours = workdir.child("merge_neighbours");
        YPath newEdgesBetween = workdir.child("edgesBetween");
        YPath newEdgesIn = workdir.child("edgesIn");


        var applyMergeTask = new ApplyMergeTask(
                dao, workdir.child("merge_apply"), null, null
        );

        if (yt.cypress().exists(workdir)) {
            yt.cypress().remove(workdir);
        }

        yt.cypress().create(workdir, CypressNodeType.MAP, true, true);
        yt.cypress().copy(decisions, tmpDecisions);
        yt.cypress().copy(mergeNeighbours, tmpMergeNeighbours);

        applyMergeTask.applyMergeDecisionsToEdgesBetween(
                tmpDecisions,
                tmpMergeNeighbours,
                edgesBetween,
                newEdgesIn,
                newEdgesBetween
        );
    }
}
