package ru.yandex.crypta.graph2.matching.human.workflow.neighbours.ops;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.model.matching.component.ComponentNeighbours;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.inside.yt.kosher.impl.operations.utils.ReducerWithKey;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;

public class CalculateComponentNeighbours implements ReducerWithKey<MergeOffer, ComponentNeighbours, String> {

    @Override
    public String key(MergeOffer entry) {
        return entry.getFromCryptaId();
    }

    @Override
    public void reduce(String cryptaId, IteratorF<MergeOffer> offers, Yield<ComponentNeighbours> yield,
                       Statistics statistics) {
        SetF<String> neighbours = offers.toList().map(MergeOffer::getToCryptaId)
                .filter(c -> !c.equals(cryptaId))
                .unique();


        if (neighbours.isNotEmpty()) {
            ComponentNeighbours componentNeighbours = new ComponentNeighbours(cryptaId,
                    neighbours);
            yield.yield(componentNeighbours);
        }
    }
}
