package ru.yandex.crypta.graph2.matching.human.workflow.neighbours.ops;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.dao.yt.bendable.YsonCachedSerializerSupport;
import ru.yandex.crypta.graph2.model.matching.component.ComponentNeighbours;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.proto.EdgeInComponent;
import ru.yandex.inside.yt.kosher.impl.operations.utils.ReducerWithKey;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;


public class CalculateComponentNeighboursReducer extends YsonCachedSerializerSupport implements ReducerWithKey<EdgeInComponent, YTreeMapNode, String>, YtSerializable {

    @Override
    public String key(EdgeInComponent entry) {
        return entry.getCryptaId();
    }

    private String getDestinationCryptaId(String cryptaId, String mergeKey) {
        MergeKey.CryptaIds cryptaIds = MergeKey.CryptaIds.fromMergeKey(mergeKey);
        return cryptaId.equals(cryptaIds.leftCryptaId) ?
                cryptaIds.rightCryptaId :
                cryptaIds.leftCryptaId;
    }

    @Override
    public void reduce(String cryptaId, IteratorF<EdgeInComponent> entries, Yield<YTreeMapNode> yield,
                       Statistics statistics) {
        SetF<String> neighbours = entries
                .map(e -> getDestinationCryptaId(cryptaId, e.getMergeKey()))
                .filter(c -> !c.equals(cryptaId))
                .toList()
                .unique();

        if (neighbours.isNotEmpty()) {
            yield.yield(serialize(new ComponentNeighbours(cryptaId, neighbours)));
        }
    }

    @Override
    public YTableEntryType<EdgeInComponent> inputType() {
        return YTableEntryTypes.nativeProto(EdgeInComponent.class);
    }

}
