package ru.yandex.crypta.graph2.matching.human.workflow.neighbours.ops;

import ru.yandex.crypta.graph2.model.matching.proto.EdgeBetweenComponents;
import ru.yandex.crypta.graph2.model.matching.proto.EdgeInComponent;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.operations.map.Mapper;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;

public class ConvertEdgeBetweenToEdgeInMapper implements Mapper<EdgeBetweenComponents, EdgeInComponent>, YtSerializable {

    @Override
    public void map(EdgeBetweenComponents edge, Yield<EdgeInComponent> yield, Statistics statistics) {

        var finalEdge =
                ru.yandex.crypta.graph2.model.matching.proto.EdgeInComponent.newBuilder()
                .setId1(edge.getId1())
                .setId1Type(edge.getId1Type())
                .setId2(edge.getId2())
                .setId2Type(edge.getId2Type())
                .setLogSource(edge.getLogSource())
                .setSourceType(edge.getSourceType())
                .setIndevice(edge.getIndevice())
                .setDatesWeight(edge.getDatesWeight())
                .setSurvivalWeight(edge.getSurvivalWeight())
                .setMergeKey(edge.getMergeKey())
                .setMergeKeyType(edge.getMergeKeyType());

        finalEdge.setCryptaId(edge.getLeftCryptaId());
        yield.yield(finalEdge.build());

        finalEdge.setCryptaId(edge.getRightCryptaId());
        yield.yield(finalEdge.build());
    }

    @Override
    public YTableEntryType<EdgeBetweenComponents> inputType() {
        return YTableEntryTypes.nativeProto(EdgeBetweenComponents.class);
    }

    @Override
    public YTableEntryType<EdgeInComponent> outputType() {
        return YTableEntryTypes.nativeProto(EdgeInComponent.class);
    }
}
