package ru.yandex.crypta.graph2.matching.human.workflow.neighbours.ops;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.dao.yt.bendable.YsonMultiEntityReducerWithKey;
import ru.yandex.crypta.graph2.model.matching.edge.EdgeBetweenComponents;
import ru.yandex.crypta.graph2.model.matching.edge.EdgeInComponent;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

public class ProcessMergeOffers extends YsonMultiEntityReducerWithKey<MergeKey> {

    private static final int MERGE_OFFERS_IN_INDEX = 0;
    private static final int EDGES_BETWEEN_IN_INDEX = 1;

    private static final int MERGE_OFFERS_OUT_INDEX = 0;
    private static final int EDGES_BETWEEN_OUT_INDEX = 1;

    @Override
    public MergeKey key(YTreeMapNode entry) {
        return parse(entry, MergeKey.class);
    }

    @Override
    public void reduce(MergeKey mergeKey, IteratorF<YTreeMapNode> entries, Yield<YTreeMapNode> yield,
            Statistics statistics) {
        ListF<MergeOffer> mergeOffers = Cf.arrayList();
        ListF<EdgeBetweenComponents> edges = Cf.arrayList();

        for (YTreeMapNode rec : entries.toList()) {
            if (getTableIndex(rec) == MERGE_OFFERS_IN_INDEX) {
                mergeOffers.add(parse(rec, MergeOffer.class));
            } else if (getTableIndex(rec) == EDGES_BETWEEN_IN_INDEX) {
                edges.add(parse(rec, EdgeBetweenComponents.class));
            }
        }

        if (mergeOffers.isNotEmpty()) {

            // all offers here must be the same, but source crypta ids may've been changed
            MergeOffer prototype = mergeOffers.first();
            ListF<String> leftCryptaIds = mergeOffers.filter(MergeOffer::isOpposite).map(MergeOffer::getFromCryptaId);
            ListF<String> rightCryptaIds = mergeOffers.filter(mo -> !mo.isOpposite()).map(MergeOffer::getFromCryptaId);
            SetF<String> allAffectedCryptaIds = leftCryptaIds.plus(rightCryptaIds).unique();

            for (String leftCryptaId : leftCryptaIds) {
                for (String rightCryptaId : rightCryptaIds) {
                    MergeOffer offer = prototype.copyWithChangedCryptaIds(leftCryptaId, rightCryptaId);
                    yield.yield(MERGE_OFFERS_OUT_INDEX, serialize(offer));
                    yield.yield(MERGE_OFFERS_OUT_INDEX, serialize(offer.opposite()));
                }
            }

            for (String cryptaId : allAffectedCryptaIds) {
                for (EdgeBetweenComponents edge : edges) {
                    EdgeInComponent edgeTmp = EdgeInComponent.fromEdge(edge.getEdge(), cryptaId);
                    edgeTmp.setMergeKey(edge.getMergeKey());
                    yield.yield(EDGES_BETWEEN_OUT_INDEX, serialize(edgeTmp));
                }
            }
        }

    }


}
