package ru.yandex.crypta.graph2.matching.human.workflow.output;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.crypta.graph2.matching.human.config.HumanMatchingConfig;
import ru.yandex.crypta.graph2.matching.human.paths.ComponentsRawTables;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.workflow.Task;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.concurrent.ExecutorUtils;

public class JoinHeavyColumnsBackTask extends Task<ComponentsRawTables, YPath, HumanMatchingConfig> {

    public JoinHeavyColumnsBackTask(Dao dao, YPath workdir, HumanMatchingConfig config, String nameSuffix) {
        super(dao, workdir, config, nameSuffix);
    }

    @Override
    protected void runImpl(ComponentsRawTables in) {

        // trying to make reduce instead of map reduce
        dao.ytOps().sortSync(in.edgesTable, Edge.EDGE_UNIQUE_KEY);

        dao.ytTr().withTransaction(tx -> {

            Runnable joinEdges = () -> dao.yql().executeInTransaction(tx.getId(),
                    "PRAGMA simplecolumns;\n" +
                            "\n" +
                            "$edgesTable='{edgesTable}';\n" +
                            "$soupEdgesTable='{soupEdgesTable}';\n" +
                            "\n" +
                            "INSERT INTO $edgesTable\n WITH TRUNCATE\n" +
                            "SELECT\n" +
                            "b.dates as dates,\n" +
                            "a.* WITHOUT a.dates\n" +
                            "FROM ANY $edgesTable as a\n" +
                            "LEFT JOIN ANY $soupEdgesTable as b\n" +
                            "USING (id1Type, id2Type, sourceType, logSource, id1, id2);",
                    Cf.map(
                            "edgesTable", in.edgesTable.justPath().toString(),
                            "soupEdgesTable", params.soupEdgesTable
                    )
            );

            Runnable joinVp = () -> dao.yql().executeInTransaction(tx.getId(),
                    "PRAGMA simplecolumns;\n" +
                            "\n" +
                            "$vpTable='{vpTable}';\n" +
                            "$soupVpTable='{soupVpTable}';\n" +
                            "\n" +
                            "INSERT INTO $vpTable\n WITH TRUNCATE\n" +
                            "SELECT\n" +
                            "b.dates as dates,\n" +
                            "a.* WITHOUT a.dates\n" +
                            "FROM $vpTable as a\n" +
                            "LEFT JOIN ANY $soupVpTable as b\n" +
                            "USING (id, id_type);",
                    Cf.map(
                            "vpTable", in.verticesPropertiesTable.justPath().toString(),
                            "soupVpTable", params.soupVerticesPropertiesTable
                    )
            );

            ListF<Runnable> operations = Cf.list(
                    joinEdges,
                    joinVp
            );
            ExecutorUtils.executeAll("yql", 2, operations, Runnable::run);


        });


    }

    @Override
    public YPath getOutput() {
        return workdir;
    }

    @Override
    public String getDescription() {
        return "Join back heavy columns";
    }
}
