package ru.yandex.crypta.graph2.matching.human.workflow.prepare;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.crypta.graph2.dao.yt.ops.Await;
import ru.yandex.crypta.graph2.matching.human.paths.ComponentsRawTables;
import ru.yandex.crypta.graph2.model.matching.component.ComponentCenter;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class ConcatTablesHelper {

    private Dao dao;

    public ConcatTablesHelper(Dao dao) {
        this.dao = dao;
    }

    public ComponentsRawTables concatComponents(ListF<ComponentsRawTables> tables, ComponentsRawTables out) {

        ListF<ComponentsRawTables> tablesL = Cf.wrap(tables);

        dao.ytTr().withTransactionId(trId -> {

            // to fix schema issues
            dao.ytCypress().remove(trId, out.verticesTable);
            dao.ytCypress().remove(trId, out.verticesPropertiesTable);
            dao.ytCypress().remove(trId, out.edgesTable);

            Await.all(
                    dao.ytOps().sortAsync(
                            trId,
                            tablesL.flatMap(t -> Cf.list(t.verticesTable)),
                            out.verticesTable,
                            ComponentCenter.CRYPTA_ID_KEY),
                    dao.ytOps().sortAsync(
                            trId,
                            tablesL.flatMap(t -> Cf.list(t.verticesPropertiesTable)),
                            out.verticesPropertiesTable,
                            ComponentCenter.CRYPTA_ID_KEY),
                    dao.ytOps().sortAsync(
                            trId,
                            tablesL.flatMap(t -> Cf.list(t.edgesTable)),
                            out.edgesTable,
                            ComponentCenter.CRYPTA_ID_KEY)
            );
        });

        return out;

    }


    public <T> YPath mergeTablesWithSchemaFromOutput(ListF<YPath> tables, YPath outputTable, Class<T> outSchemaClazz) {
        dao.ytTr().withTransactionId(trId -> {

                    dao.ytCypress().createTableWithSchema(trId, outputTable, outSchemaClazz);
                    dao.ytOps().mergeWithSchemaFromOutput(
                            trId,
                            tables,
                            outputTable
                    );
                }
        );

        return outputTable;
    }

}
