package ru.yandex.crypta.graph2.matching.human.workflow.prepare.ops;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph.engine.proto.TStatsOptions;
import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.crypta.graph2.dao.yql.Yql;
import ru.yandex.crypta.graph2.dao.yql.YqlConfig;
import ru.yandex.crypta.graph2.dao.yt.YtConfig;
import ru.yandex.crypta.graph2.dao.yt.ops.YtOpsParams;
import ru.yandex.crypta.graph2.model.matching.component.ComponentCenter;
import ru.yandex.crypta.graph2.model.matching.component.score.NativeHumanScoringStrategy;
import ru.yandex.crypta.graph2.model.matching.edge.EdgeInComponent;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.proto.ComponentToMerge;
import ru.yandex.crypta.graph2.model.matching.vertex.VertexInComponent;
import ru.yandex.crypta.graph2.model.soup.props.VertexPropertiesSchemaHelper;
import ru.yandex.crypta.graph2.utils.NativeLibHelper;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.CypressNodeType;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class PutComponentsToMergeKeyTestRun {


    public static void main(String[] args) {

        NativeLibHelper.setLocalJavaLibraryPath();
        Yt yt = YtConfig.getYt(true);
        Yql yql = YqlConfig.getYql();

        Dao dao = new Dao(yt, yql, new YtOpsParams());

        YPath indir = YPath.simple("//home/crypta/production/state/graph/v2/matching/workdir/init");
        ListF<YPath> inTables = Cf.list(
                indir.child("merge_neighbours"),
                indir.child("vertices_with_crypta_ids"),
                indir.child("vertices_properties_crypta_id"),
                indir.child("soup_edges_crypta_id")
        );

        YPath workdir = YPath.simple("//home/crypta/team/atanna/matching/workdir/components_test2");

        dao.yt().cypress().create(workdir, CypressNodeType.MAP, true, true);
        YPath componentsToMerge = workdir.child("components_by_merge_key");
        YPath verticesWithNeighbours = workdir.child("vertices_with_neighbours");
        YPath verticesPropertiesWithNeighbours = workdir.child("vertices_properties_with_neighbours");
        YPath edgesWithNeighbours = workdir.child("edges_with_neighbours");

        YPath verticesNoNeighbours = workdir.child("vertices_no_neighbours");
        YPath verticesPropertiesNoNeighbours = workdir.child("vertices_properties_no_neighbours");
        YPath edgesNoNeighbours = workdir.child("edges_no_neighbours");

        dao.ytCypress().createTableWithSchema(componentsToMerge, ComponentToMerge.class);
        dao.ytCypress().createTableWithSchema(verticesWithNeighbours, VertexInComponent.class);
        dao.ytCypress().createTableWithSchema(
                    verticesPropertiesWithNeighbours,
                    VertexPropertiesSchemaHelper.getUnionVertexPropertiesSchema()
        );
        dao.ytCypress().createTableWithSchema(edgesWithNeighbours, EdgeInComponent.class);
        dao.ytCypress().createTableWithSchema(verticesNoNeighbours, VertexInComponent.class);
        dao.ytCypress().createTableWithSchema(
                verticesPropertiesNoNeighbours,
                VertexPropertiesSchemaHelper.getUnionVertexPropertiesSchema()
        );
        dao.ytCypress().createTableWithSchema(edgesNoNeighbours, EdgeInComponent.class);

        ListF<YPath> outTables = Cf.list(
                componentsToMerge, verticesWithNeighbours, verticesPropertiesWithNeighbours,
                edgesWithNeighbours, verticesNoNeighbours, verticesPropertiesNoNeighbours,
                edgesNoNeighbours
        );
        TStatsOptions options = TStatsOptions.newBuilder().setCrossDeviceWeight(7.5).build();
        dao.ytOps().reduceSync(
                inTables,
                outTables,
                ComponentCenter.CRYPTA_ID_KEY,
                new PutComponentsToMergeKey(new NativeHumanScoringStrategy(options))
        );

        dao.ytOps().sortOperation(Cf.list(componentsToMerge), componentsToMerge, MergeKey.REDUCE_KEY).runSync();
    }
}
