package ru.yandex.crypta.graph2.model.matching.component;

import java.util.Comparator;

import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class ComponentCenterWithWeight {

    public static final Comparator<ComponentCenterWithWeight> BY_CC_WEIGHT = Comparator
            .comparingDouble(ComponentCenterWithWeight::getCcWeight)
            .thenComparing(ComponentCenterWithWeight::getComponentCenter);

    @YTreeField
    @YTreeFlattenField
    private ComponentCenter componentCenter;

    @YTreeField
    private double ccWeight;

    public ComponentCenterWithWeight(ComponentCenter componentCenter) {
        this.componentCenter = componentCenter;
    }

    public ComponentCenterWithWeight(ComponentCenter componentCenter, double ccWeight) {
        this.componentCenter = componentCenter;
        this.ccWeight = ccWeight;
    }

    public ComponentCenter getComponentCenter() {
        return componentCenter;
    }

    public double getCcWeight() {
        return ccWeight;
    }


    public void setCcWeight(double ccWeight) {
        this.ccWeight = ccWeight;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ComponentCenterWithWeight that)) return false;

        return componentCenter.equals(that.componentCenter);
    }

    @Override
    public int hashCode() {
        return componentCenter.hashCode();
    }
}
