package ru.yandex.crypta.graph2.model.matching.component;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph2.model.matching.score.MetricsTree;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.graph2.utils.MapCounter;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class ComponentStats {

    @YTreeField
    @YTreeFlattenField
    @SuppressWarnings("UnusedVariable")
    private ComponentCenter cryptaId;

    @YTreeField
    @SuppressWarnings("UnusedVariable")
    private int verticesCount;

    @YTreeField
    @SuppressWarnings("UnusedVariable")
    private MapF<String, Integer> idTypesStats = Cf.hashMap();

    @YTreeField
    @SuppressWarnings("UnusedVariable")
    private MetricsTree score;

    private ComponentStats(ComponentCenter cryptaId) {
        this.cryptaId = cryptaId;
    }

    public static ComponentStats calculate(ComponentCenter componentCenter, Component component) {
        ComponentStats stats = new ComponentStats(componentCenter);
        stats.verticesCount = component.size();

        MapCounter<String, Vertex> vertexTypeCounter = new MapCounter<>();
        for (Vertex vertex : component.getVertices()) {
            vertexTypeCounter.add(Soup.CONFIG.name(vertex.getIdType()), vertex);
        }
        stats.idTypesStats = vertexTypeCounter.getKeysCounts();

        stats.score = component.getScoreTree();

        return stats;

    }

}
