package ru.yandex.crypta.graph2.model.matching.component;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.model.soup.props.VertexPropertiesCollector;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

public class GraphInfo {

    public MapF<String, Component> components = Cf.hashMap();
    public MapF<Vertex, Component> vertexToComponents = Cf.hashMap();
    public VertexPropertiesCollector verticesProperties = new VertexPropertiesCollector();
    public ListF<Edge> edgesBetweenComponents = Cf.arrayList();

    public ListF<MergeOffer> neighbourMergeOffers = Cf.arrayList();
    public Option<IteratorF<YTreeMapNode>> restRecords = Option.empty();

    public GraphInfo() {
    }

    public GraphInfo(MapF<String, Component> components, MapF<Vertex, Component> vertexToComponents,
                     VertexPropertiesCollector verticesProperties, ListF<Edge> edgesBetweenComponents) {
        this.components = components;
        this.vertexToComponents = vertexToComponents;
        this.verticesProperties = verticesProperties;
        this.edgesBetweenComponents = edgesBetweenComponents;
    }

    public CollectionF<Component> getComponents() {
        return components.values();
    }

    @Override
    public String toString() {
        return "GraphInfo{" + "\n" +
                "components=" + components + ",\n" +
                // full vertexToComponents toString() causes overflow
                "vertexToComponents=" + vertexToComponents.mapValues(Component::getCryptaId) + ",\n" +
                "verticesProperties=" + verticesProperties + ",\n" +
                "edgesBetweenComponents=" + edgesBetweenComponents + ",\n" +
                '}';
    }
}
