package ru.yandex.crypta.graph2.model.matching.component;

import com.google.protobuf.InvalidProtocolBufferException;

import ru.yandex.crypta.graph.engine.proto.TGraph;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class GraphRecord {

    @YTreeField
    private String cryptaId;

    @YTreeField
    private byte[] graph;

    public GraphRecord(String cryptaId, Component component, GraphInfo graphInfo) {
        this.cryptaId = cryptaId;
        graph = component.computeTGraph(graphInfo).toByteArray();
    }

    public TGraph extractGraph() throws InvalidProtocolBufferException {
        return TGraph.parseFrom(graph);
    }

    @Override
    public String toString() {
        return "Component{" +
                "cryptaId=" + cryptaId + "}";
    }
}
