package ru.yandex.crypta.graph2.model.matching.component.score;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.score.MetricsTree;
import ru.yandex.crypta.graph2.model.soup.props.Outlier;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;

public class AnomalyScoringStrategy implements ComponentScoringStrategy {
    private String name;
    private String description;

    public AnomalyScoringStrategy(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    public MetricsTree scoreTree(Component component, GraphInfo graphInfo) {
        double score;

        MapF<Vertex, Outlier> outliers = graphInfo.verticesProperties.getOutliers();
        SetF<Vertex> componentVerteces = component.getVertices();

        Function1B<Map.Entry<Vertex, Outlier>> goodKeyPredicate = (x) -> componentVerteces.containsTs(x.getKey());
        outliers = outliers.filterEntries(goodKeyPredicate);

        if (outliers.size() == 0) {
            score = 1.0;
        } else {
            final Comparator<Outlier> comp = Comparator.comparingDouble(Outlier::getAnomalyScore);
            Optional<Outlier> minOutlier = outliers.values().stream().min(comp); // min because the less the more anomaly

            if (minOutlier.isPresent()) {
                if (minOutlier.get().getAnomalyScore() <= -0.75) {
                    score = 0.0;
                } else {
                    score = 1.0;
                }
            } else {
                throw new RuntimeException("Outlier vertex is Empty.");
            }
        }
        return new MetricsTree(scoreToProb(score));
    }

    private double scoreToProb(double score) {
        return (score + 1) / 2.0; // score is in [-1; 1]; prob is in [0, 1]
    }

    @Override
    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }
}
