package ru.yandex.crypta.graph2.model.matching.component.score;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.crypta.graph.engine.proto.TStats;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.score.MetricsTree;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;


/**
 * Estimates single component quality
 */
public interface ComponentScoringStrategy extends YtSerializable {

    MetricsTree scoreTree(Component component, GraphInfo graphInfo);

    default TStats stats(Component component, GraphInfo graphInfo) {
        return scoreTree(component, graphInfo).convertToTStats();
    }

    default void setScoreTree(Component component, GraphInfo graphInfo) {
        if (component.getScoreTree() == null) {
            component.setScoreTree(scoreTree(component, graphInfo));
        }
    }

    default void setScoreTree(Component component, GraphInfo graphInfo, boolean force) {
        if (force) {
            component.setScoreTree(scoreTree(component, graphInfo));
        }
        else {
            setScoreTree(component, graphInfo);
        }
    }

    default void setScoreTreeWeakForce(Component component, GraphInfo graphInfo) {
        if (component.getScoreTree() == null || Math.abs(component.getScoreTree().getScore()) <= Double.MIN_VALUE) {
            setScoreTree(component, graphInfo, true);
        }
    }

    default void setScoreTree(CollectionF<Component> components, GraphInfo graphInfo) {
        for (Component component : components) {
            setScoreTree(component, graphInfo);
        }
    }

    String getName();

}
