package ru.yandex.crypta.graph2.model.matching.component.score;

import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.score.MetricsTree;

public class HumanMultiHistogramScoringExperimental implements ComponentScoringStrategy {
    protected WeightedMultiScoringStrategy weighted;

    public HumanMultiHistogramScoringExperimental(boolean requireYandexuidForPersonalIds, Option<Double> crossDeviceWeight) {

        AnomalyScoringStrategy anomalyScoreHist =
                new AnomalyScoringStrategy("anomaly_score", "Anomaly score");

        HumanMultiHistogramScoringStrategy originalStrategy = new HumanMultiHistogramScoringStrategy(requireYandexuidForPersonalIds, crossDeviceWeight);
        this.weighted = originalStrategy.weighted
                .weighting(anomalyScoreHist, 1);
    }

    @Override
    public MetricsTree scoreTree(Component component, GraphInfo graphInfo) {
        return this.weighted.scoreTree(component, graphInfo);
    }

    @Override
    public String getName() {
        return "Experimental scoring strategy";
    }
}
