package ru.yandex.crypta.graph2.model.matching.component.score;

import ru.yandex.crypta.graph.engine.proto.TStats;
import ru.yandex.crypta.graph.engine.proto.TStatsOptions;
import ru.yandex.crypta.graph.engine.score.stats.EngineHelper;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.score.MetricsTree;

public class NativeHumanScoringStrategy implements ComponentScoringStrategy {

    final private TStatsOptions statsOptions;
    private boolean isExperiment = false;

    public NativeHumanScoringStrategy(TStatsOptions statsOptions, boolean isExperiment) {
        this.statsOptions = statsOptions;
        this.isExperiment = isExperiment;
    }

    public NativeHumanScoringStrategy(TStatsOptions statsOptions) {
        this(statsOptions, false);
    }

    @Override
    public MetricsTree scoreTree(Component component, GraphInfo graphInfo) {
        TStats stats = collectStats(component, graphInfo);
        return MetricsTree.buildFromTStats(stats);
    }

    @Override
    public TStats stats(Component component, GraphInfo graphInfo) {
        return collectStats(component, graphInfo);
    }

    public TStats collectStats(Component component, GraphInfo graphInfo) {
        if (isExperiment) {
            return EngineHelper.collectExpStats(component.computeTGraph(graphInfo), statsOptions);

        }
        return EngineHelper.collectProdStats(component.computeTGraph(graphInfo), statsOptions);
    }

    @Override
    public String getName() {
        return "nativeHuman";
    }
}
