package ru.yandex.crypta.graph2.model.matching.component.score;

import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.score.MetricsTree;

public class SimpleStupidScoringStrategy implements ComponentScoringStrategy {

    private int maxComponentSize = 200;

    public SimpleStupidScoringStrategy(int maxComponentSize) {
        this.maxComponentSize = maxComponentSize;
    }

    public SimpleStupidScoringStrategy() {
    }

    @Override
    public MetricsTree scoreTree(Component component, GraphInfo graphInfo) {
        if (component.size() == 0) {
            // empty crypta component is the worst one
            return new MetricsTree(-1);
        } else if (component.size() > maxComponentSize) {
            // huge penalty for crypta component larger than maxComponentSize ids
            return new MetricsTree(0);
        } else {
            // otherwise bigger is better
            return new MetricsTree((double) component.size() / 100);
        }
    }

    @Override
    public String getName() {
        return "simple";
    }
}
