package ru.yandex.crypta.graph2.model.matching.component.score;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.score.MetricsTree;

public class WeightedMultiScoringStrategy implements ComponentScoringStrategy {

    private MapF<ComponentScoringStrategy, Double> inner = Cf.hashMap();

    @Override
    public MetricsTree scoreTree(Component component, GraphInfo graphInfo) {
        MapF<String, Double> weightedMetrics = inner.mapEntries(
                (cp, w) -> Tuple2.tuple(cp.getName(), cp.scoreTree(component, graphInfo).getScore() * w)
        ).toMap(t -> t);

        double weightsSum = weightedMetrics.values().stream().mapToDouble(w -> w).sum();

        return new MetricsTree(weightsSum, weightedMetrics);
    }

    @Override
    public String getName() {
        return "weighted";
    }

    public WeightedMultiScoringStrategy weighting(ComponentScoringStrategy scorer, double weight) {
        this.inner.put(scorer, weight);
        return this;
    }

    public WeightedMultiScoringStrategy weighting(ComponentScoringStrategy scorer, Option<Double> weight) {
        if (weight.isPresent()) {
            return weighting(scorer, weight.get());
        }
        return this;
    }


}
