package ru.yandex.crypta.graph2.model.matching.component.score.extractors;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.soup.props.UaProfile;
import ru.yandex.crypta.graph2.model.soup.props.Yandexuid;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;

public class CrossDeviceCountExtractor implements IdsCountExtractor {

    @Override
    public Integer apply(Component cp, GraphInfo graphInfo) {
        if (new DevicesCountExtractor(true).apply(cp, graphInfo) == 0) {
            return 0;
        }
        SetF<Vertex> yuids = cp.getVertices().filter(v -> v.getIdType() == EIdType.YANDEXUID);

        MapF<Vertex, Yandexuid> yuidsInfo = graphInfo.verticesProperties.getYuids();
        if (yuids.filter(
                v -> yuidsInfo.containsKeyTs(v) && isItActiveDesktop(yuidsInfo.getTs(v))
        ).isNotEmpty()) {
            return 1;
        }
        return 0;
    }

    private boolean isItActiveDesktop(Yandexuid yuid) {
        return yuid.isActive() && new UaProfile(yuid.getUaProfile()).isDesktop();
    }
}
