package ru.yandex.crypta.graph2.model.matching.component.score.extractors;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.soup.props.DeviceId;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;

public class DevicesCountExtractor implements IdsCountExtractor {

    private final boolean withActivity;

    public DevicesCountExtractor(boolean withActivity) {
        this.withActivity = withActivity;
    }

    @Override
    public Integer apply(Component component, GraphInfo graphInfo) {
        SetF<Vertex> deviceVertices = component.getVertices().filter(
                v -> Soup.CONFIG.isDeviceIdMainId(v.getIdType())
        );

        MapF<Vertex, DeviceId> deviceIdsInfo = graphInfo.verticesProperties.getDeviceIds();

        if (deviceVertices.isEmpty() || deviceIdsInfo.isEmpty()) {
            return 0;
        }

        if (withActivity) {
            return deviceVertices.filter(
                    v -> deviceIdsInfo.containsKeyTs(v) && deviceIdsInfo.getTs(v).isActive()
            ).size();
        } else {
            return deviceVertices.size();
        }
    }
}
