package ru.yandex.crypta.graph2.model.matching.component.score.extractors;

import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;

public class EmailsCountExtractor implements IdsCountExtractor {

    private final boolean linkedYandexuidRequired;
    private final IdsCountExtractor emailCounter = new IdTypeVerticesCountExtractor(EIdType.EMAIL);
    private final IdsCountExtractor yandexuidsCounter = new YandexuidsCountExtractor(false);

    public EmailsCountExtractor(boolean linkedYandexuidRequired) {
        this.linkedYandexuidRequired = linkedYandexuidRequired;
    }


    @Override
    public Integer apply(Component component, GraphInfo graphInfo) {
        if (linkedYandexuidRequired && yandexuidsCounter.apply(component, graphInfo) == 0) {
            return 0;
        }

        return emailCounter.apply(component, graphInfo);
    }
}
