package ru.yandex.crypta.graph2.model.matching.component.score.extractors;

import com.google.common.base.Splitter;

import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.soup.props.Login;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;


public class EmailsLcsExtractor extends IdsLcsExtractor {
    @Override
    public SetF<String> getIds(Component cp) {
        SetF<String> emails = cp.getVertices()
            .filter(v -> v.getIdType().equals(EIdType.EMAIL))
            .map(Vertex::getId)
            .unique();

        return emails.map(email -> Splitter.on("@").split(email).iterator().next())
                .filter(email -> !Login.isSyntheticLogin(email))
                .unique();
    }
}
