package ru.yandex.crypta.graph2.model.matching.component.score.extractors;

import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;

public class IdTypeVerticesCountExtractor implements IdsCountExtractor {

    private final EIdType idType;

    public IdTypeVerticesCountExtractor(EIdType idType) {
        this.idType = idType;
    }

    @Override
    public Integer apply(Component component, GraphInfo graphInfo) {
        return component.getVertices().count(v -> v.getIdType() == idType);
    }
}
