package ru.yandex.crypta.graph2.model.matching.component.score.extractors;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;


public abstract class IdsLcsExtractor implements IdsCountExtractor {
    abstract SetF<String> getIds(Component cp);

    private static String getLcs(String a, String b) {
        int m = a.length();
        int n = b.length();

        int max = 0;
        int maxI = 0;
        int maxJ = 0;

        int[][] dp = new int[m][n];

        for(int i = 0; i < m; i++){
            for(int j = 0; j < n; j++){
                if(a.charAt(i) == b.charAt(j)) {
                    if (i == 0 || j == 0) {
                        dp[i][j] = 1;
                    } else {
                        dp[i][j] = dp[i - 1][j - 1] + 1;
                    }

                    if (max < dp[i][j]) {
                        max = dp[i][j];
                        maxI = i;
                        maxJ = j;
                    }
                }
            }
        }
        String lcs = "";
        if (max > 0) {
            lcs = a.substring(maxI - dp[maxI][maxJ] + 1,  maxI + 1);
        }

        return lcs;
    }

    @Override
    public Integer apply(Component cp, GraphInfo graphInfo) {
        SetF<String> ids = this.getIds(cp);
        if (ids.size() < 2) {
            return 0;
        }
        IteratorF<String> idsIter = ids.sorted().iterator();
        String lcs = idsIter.nextO().get();
        while (idsIter.hasNext()) {
            lcs = getLcs(lcs, idsIter.nextO().get());
        }
        return lcs.length();
    }
}
