package ru.yandex.crypta.graph2.model.matching.component.score.extractors;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.model.soup.edge.EdgeType;
import ru.yandex.crypta.graph2.model.soup.props.Login;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;

import static ru.yandex.crypta.graph.soup.config.proto.ELogSourceType.PASSPORT_DICT;
import static ru.yandex.crypta.graph.soup.config.proto.ESourceType.PASSPORT_PROFILE;
import static ru.yandex.crypta.lib.proto.identifiers.EIdType.LOGIN;
import static ru.yandex.crypta.lib.proto.identifiers.EIdType.PUID;

public class LoginsCountExtractor implements IdsCountExtractor {

    public static final EdgeType PUID_LOGIN_EDGE_TYPE = new EdgeType(PUID, LOGIN, PASSPORT_PROFILE, PASSPORT_DICT);

    private final boolean linkedYandexuidRequired;
    private final YandexuidsCountExtractor yandexuidsCounter = new YandexuidsCountExtractor(false);

    public LoginsCountExtractor(boolean linkedYandexuidRequired) {
        this.linkedYandexuidRequired = linkedYandexuidRequired;
    }

    @Override
    public Integer apply(Component cp, GraphInfo graphInfo) {

        if (linkedYandexuidRequired && yandexuidsCounter.apply(cp, graphInfo) == 0) {
            return 0;
        }

        MapF<String, String> puid2Login = cp.getInnerEdges()
                .filter(e -> e.calculateEdgeType().equals(PUID_LOGIN_EDGE_TYPE))
                .toMap(Edge::getId1, Edge::getId2);

        SetF<String> logins = cp.getVertices()
                .filter(v -> v.getIdType().equals(EIdType.LOGIN))
                .map(Vertex::getId)
                .unique();

        SetF<String> unknownPuidsWithoutLogin = cp.getVertices()
                .filter(v -> v.getIdType().equals(EIdType.PUID))
                .map(Vertex::getId)
                .filter(puid -> !puid2Login.containsKeyTs(puid))
                .unique();

        SetF<String> goodLogins = logins.filter(login -> !Login.isSyntheticLogin(login));

        return goodLogins.size() + unknownPuidsWithoutLogin.size();
    }
}
