package ru.yandex.crypta.graph2.model.matching.component.score.extractors;

import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.soup.props.Login;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;


public class LoginsLcsExtractor extends IdsLcsExtractor {
    @Override
    public SetF<String> getIds(Component cp) {
        SetF<String> logins = cp.getVertices()
                .filter(v -> v.getIdType().equals(EIdType.LOGIN))
                .map(Vertex::getId)
                .unique();

        return logins.filter(login -> !Login.isSyntheticLogin(login));
    }
}
