package ru.yandex.crypta.graph2.model.matching.component.score.extractors;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.soup.props.Yandexuid;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;

public class YandexuidsCountExtractor implements IdsCountExtractor {
    private final boolean withActivity;

    public YandexuidsCountExtractor(boolean withActivity) {
        this.withActivity = withActivity;
    }

    @Override
    public Integer apply(Component component, GraphInfo graphInfo) {
        SetF<Vertex> vertices = component.getVertices().filter(
                v -> v.getIdType() == EIdType.YANDEXUID
        );

        if (withActivity) {
            MapF<Vertex, Yandexuid> yuids = graphInfo.verticesProperties.getYuids();
            return vertices.filter(
                    v -> yuids.containsKeyTs(v) && yuids.getTs(v).isActive()
            ).size();
        } else {
            return vertices.size();
        }
    }
}
