package ru.yandex.crypta.graph2.model.matching.component.similarity;

import org.apache.commons.math3.stat.StatUtils;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.soup.props.VertexPropertiesCollector;
import ru.yandex.crypta.graph2.model.soup.props.info.ExactSocdem;
import ru.yandex.crypta.graph2.model.soup.props.info.ExactSocdem.Gender;
import ru.yandex.crypta.graph2.utils.FreqUtils;

public class ComponentsExactSocdemSimilarityStrategy extends ComponentsSimilarityStrategy {

    @Override
    public ListF<SimilarityResult> isSimilar(Component component1, Component component2, GraphInfo graphInfo) {
        ExactSocdem component1Socdem = getAverageComponentSocdem(component1, graphInfo.verticesProperties);
        ExactSocdem component2Socdem = getAverageComponentSocdem(component2, graphInfo.verticesProperties);

        boolean genderSimilar = true;
        boolean ageSimilar = true;

        if (component1Socdem.getGender().isPresent() && component2Socdem.getGender().isPresent()) {
            genderSimilar = genderSimilar(component1Socdem.getGender().get(), component2Socdem.getGender().get());
        }

        if (component1Socdem.getYearOfBirth().isPresent() && component2Socdem.getYearOfBirth().isPresent()) {
            ageSimilar = ageSimilar(component1Socdem.getYearOfBirth().get(), component2Socdem.getYearOfBirth().get());
        }

        return SimilarityResult.of(genderSimilar && ageSimilar, "gender", isWeak);

    }

    private boolean genderSimilar(Gender gender1, Gender gender2) {
        return gender1.equals(gender2);
    }

    private boolean ageSimilar(int yob1, int yob2) {
        int yobDiff = Math.abs(yob1 - yob2);
        return yobDiff <= 1;
    }

    private ExactSocdem getAverageComponentSocdem(Component component, VertexPropertiesCollector vertexProperties) {
        ListF<ExactSocdem> exactSocdems = component.getExactSocdems(vertexProperties);

        Option<Gender> mostFreqGender = avgGender(exactSocdems);
        Option<Integer> yob = avgYearOfBirth(exactSocdems);

        // TODO: CRYPTR-605
        return new ExactSocdem(yob, mostFreqGender, Option.empty());

    }

    private Option<Integer> avgYearOfBirth(ListF<ExactSocdem> exactSocdems) {
        ListF<Integer> yobs = exactSocdems.filterMap(ExactSocdem::getYearOfBirth);
        if (yobs.isNotEmpty()) {
            return Option.of((int) StatUtils.mean(
                    yobs.mapToDoubleArray(e -> (double) e)
            ));
        } else {
            return Option.empty();
        }
    }

    private Option<Gender> avgGender(ListF<ExactSocdem> exactSocdems) {
        return FreqUtils.getMostFrequentOrEmptyIfNotSingle(
                exactSocdems.filterMap(ExactSocdem::getGender)
        );
    }
}
