package ru.yandex.crypta.graph2.model.matching.component.similarity;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.soup.props.VertexPropertiesCollector;
import ru.yandex.crypta.graph2.model.soup.props.info.ExactSocdem.Gender;
import ru.yandex.crypta.graph2.model.soup.props.info.ProbSocdem;
import ru.yandex.crypta.graph2.utils.FreqUtils;

public class ComponentsProbSocdemSimilarityStrategy extends ComponentsSimilarityStrategy {

    @Override
    public ListF<SimilarityResult> isSimilar(Component component1, Component component2, GraphInfo graphInfo) {
        Option<Gender> component1Gender = getVotedGender(component1, graphInfo.verticesProperties);
        Option<Gender> component2Gender = getVotedGender(component2, graphInfo.verticesProperties);

        if (component1Gender.isPresent() && component2Gender.isPresent()) {
            boolean probEquals = component1Gender.get().equals(component2Gender.get());
            return SimilarityResult.of(probEquals, "prob_socdem", isWeak);
        } else {
            return SimilarityResult.unknown();
        }

    }

    private Option<Gender> getVotedGender(Component component, VertexPropertiesCollector vertexProperties) {
        ListF<Gender> probGenders = component.getVertices()
                .filterMap(v -> vertexProperties.getProbSocdems().getO(v))
                .map(ProbSocdem::getGenderSegments)
                .filterMap(this::toGender);

        return FreqUtils.getMostFrequentOrEmptyIfNotSingle(probGenders);

    }

    private Option<Gender> toGender(MapF<String, Double> probGenders) {
        if (probGenders.isEmpty()) {
            return Option.empty();
        } else {

            if (probGenders.getTs("m") > 0.7) {
                return Option.of(Gender.MALE);
            }

            if (probGenders.getTs("f") > 0.7) {
                return Option.of(Gender.FEMALE);
            }

            return Option.empty();
        }
    }
}
