package ru.yandex.crypta.graph2.model.matching.component.similarity;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.soup.props.VertexPropertiesCollector;
import ru.yandex.crypta.graph2.utils.FreqUtils;

public class ComponentsRegionSimilarityStrategy extends ComponentsSimilarityStrategy {

    @Override
    public ListF<SimilarityResult> isSimilar(Component component1, Component component2, GraphInfo graphInfo) {
        Option<Integer> region1 = avgComponentRegion(component1, graphInfo.verticesProperties);
        Option<Integer> region2 = avgComponentRegion(component2, graphInfo.verticesProperties);

        if (region1.isPresent() && region2.isPresent()) {
            boolean regionSame = region1.get().equals(region2.get());
            return SimilarityResult.of(regionSame, "region", isWeak);
        } else {
            return SimilarityResult.unknown();
        }

    }

    private Option<Integer> avgComponentRegion(Component component, VertexPropertiesCollector vertexProperties) {
        ListF<Integer> regions = component.getRegions(vertexProperties);
        return FreqUtils.getMostFrequentOrEmptyIfNotSingle(regions);
    }
}
