package ru.yandex.crypta.graph2.model.matching.component.similarity;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;

public class ComponentsSimilarityMultiStrategy extends ComponentsSimilarityStrategy {

    private ListF<ComponentsSimilarityStrategy> delegates;

    public ComponentsSimilarityMultiStrategy(ListF<ComponentsSimilarityStrategy> delegates) {
        this.delegates = delegates;
    }

    @Override
    public ListF<SimilarityResult> isSimilar(Component component1, Component component2, GraphInfo graphInfo) {
        return delegates.flatMap(d -> d.isSimilar(component1, component2, graphInfo));
    }
}
