package ru.yandex.crypta.graph2.model.matching.component.similarity;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;

public abstract class ComponentsSimilarityStrategy implements YtSerializable {
    protected boolean isWeak = false;

    public ComponentsSimilarityStrategy asWeak() {
        this.isWeak = true;
        return this;
    }

    boolean isWeak() {
        return isWeak;
    }
    /**
     * @param component1 component1
     * @param component2 component2
     * @param graphInfo  graph metadata
     * @return one or more reasons why two components are similar or not. If unknown, returns empty list
     */
    public abstract ListF<SimilarityResult> isSimilar(Component component1, Component component2, GraphInfo graphInfo);
}
