package ru.yandex.crypta.graph2.model.matching.component.similarity;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class SimilarityResult {
    @YTreeField
    private boolean isSimilar;
    @YTreeField
    private String similarityType;

    private boolean isWeak = false;

    public SimilarityResult(boolean isSimilar, String similarityType) {
        this(isSimilar, similarityType, false);
    }

    public SimilarityResult(boolean isSimilar, String similarityType, boolean isWeak) {
        this.isSimilar = isSimilar;
        this.similarityType = similarityType;
        this.isWeak = isWeak;
    }

    public static ListF<SimilarityResult> of(boolean isSimilar, String similarityType) {
        return of(isSimilar, similarityType, false);
    }

    public static ListF<SimilarityResult> of(boolean isSimilar, String similarityType, boolean isWeak) {
        return Cf.list(new SimilarityResult(isSimilar, similarityType, isWeak));
    }

    public static ListF<SimilarityResult> unknown() {
        return Cf.list();
    }

    public boolean isSimilar() {
        return isSimilar;
    }

    public boolean isWeak() {
        return isWeak;
    }

    public String getSimilarityType() {
        return similarityType;
    }

    @Override
    public String toString() {
        return this.similarityType + "=" + isSimilar;
    }
}
