package ru.yandex.crypta.graph2.model.matching.edge;

import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class EdgeBetweenComponents {

    @YTreeField
    @YTreeFlattenField
    private Edge edge;

    @YTreeField
    @YTreeFlattenField
    private MergeKey mergeKey;

    @YTreeField
    private String leftCryptaId;

    @YTreeField
    private String rightCryptaId;

    public EdgeBetweenComponents(Edge edge, String leftCryptaId, String rightCryptaId) {
        this.edge = edge;
        this.leftCryptaId = leftCryptaId;
        this.rightCryptaId = rightCryptaId;
    }

    public EdgeBetweenComponents(Edge edge, MergeKey mergeKey, String leftCryptaId, String rightCryptaId) {
        this.edge = edge;
        this.mergeKey = mergeKey;
        this.leftCryptaId = leftCryptaId;
        this.rightCryptaId = rightCryptaId;
    }

    public Edge getEdge() {
        return edge;
    }

    public MergeKey getMergeKey() {
        return mergeKey;
    }

    public void setMergeKey(MergeKey mergeKey) {
        this.mergeKey = mergeKey;
    }

    public EdgeBetweenComponents withMergeKey(MergeKey mergeKey) {
        setMergeKey(mergeKey);
        return this;
    }

    public static EdgeBetweenComponents fromEdge(Edge edge, String leftCryptaId, String rightCryptaId) {
        return new EdgeBetweenComponents(edge, leftCryptaId, rightCryptaId);
    }

    public String getLeftCryptaId() {
        return leftCryptaId;
    }

    public String getRightCryptaId() {
        return rightCryptaId;
    }

    public void setLeftCryptaId(String leftCryptaId) {
        this.leftCryptaId = leftCryptaId;
    }

    public void setRightCryptaId(String rightCryptaId) {
        this.rightCryptaId = rightCryptaId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgeBetweenComponents that)) {
            return false;
        }

        if (!edge.equals(that.edge)) {
            return false;
        }
        return mergeKey.equals(that.mergeKey);
    }

    @Override
    public int hashCode() {
        int result = edge.hashCode();
        result = 31 * result + mergeKey.hashCode();
        return result;
    }
}
