package ru.yandex.crypta.graph2.model.matching.edge;

import ru.yandex.crypta.graph2.model.matching.merge.MergeKeyWithNewCryptaIds;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class EdgeBetweenWithNewCryptaIds {

    @YTreeField
    @YTreeFlattenField
    private Edge edge;

    @YTreeField
    @YTreeFlattenField
    private MergeKeyWithNewCryptaIds mergeKey;

    @YTreeField
    private boolean opposite = false;


    public EdgeBetweenWithNewCryptaIds(Edge edge, MergeKeyWithNewCryptaIds mergeKey, boolean opposite) {
        this.edge = edge;
        this.mergeKey = mergeKey;
        this.opposite = opposite;
    }

    public EdgeBetweenWithNewCryptaIds(Edge edge, MergeKeyWithNewCryptaIds mergeKey) {
        this(edge, mergeKey, false);
    }

    public EdgeBetweenWithNewCryptaIds(EdgeBetweenComponents edgeBetween, MergeKeyWithNewCryptaIds mergeKey) {
        this.edge = edgeBetween.getEdge();
        if (!edgeBetween.getLeftCryptaId().equals(edgeBetween.getRightCryptaId()) &&
             edgeBetween.getLeftCryptaId().equals(mergeKey.getRightCryptaId())) {
            this.opposite = true;
        }
        this.mergeKey = mergeKey;
    }

    public Edge getEdge() {
        return edge;
    }

    public MergeKeyWithNewCryptaIds getMergeKey() {
        return mergeKey;
    }

    public void setCryptaId(String cryptaId) {
        mergeKey.setCryptaId(cryptaId);
    }

    public String getLeftCryptaId() {
        return mergeKey.getLeftCryptaId();
    }

    public String getRightCryptaId() {
        return mergeKey.getRightCryptaId();
    }

    public boolean isOpposite() {
        return opposite;
    }

    public void setOpposite(boolean opposite) {
        this.opposite = opposite;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgeBetweenWithNewCryptaIds that)) {
            return false;
        }

        if (!edge.equals(that.edge)) {
            return false;
        }
        return mergeKey.equals(that.mergeKey);
    }

    @Override
    public int hashCode() {
        int result = edge.hashCode();
        result = 31 * result + mergeKey.hashCode();
        return result;
    }
}
