package ru.yandex.crypta.graph2.model.matching.edge;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph2.model.matching.component.ComponentCenter;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class EdgeInComponent {

    public static final ListF<String> EDGE_WITH_MULTI_CRYPTA_ID_KEY =
            Cf.list(ComponentCenter.CRYPTA_ID_COLUMN).plus(Edge.EDGE_UNIQUE_KEY);

    @YTreeField
    @YTreeFlattenField
    private Edge edge;

    // just for schema
    @YTreeField
    @YTreeFlattenField
    private MergeKey mergeKey = MergeKey.EMPTY;

    @YTreeField
    private String cryptaId;

    public EdgeInComponent(Edge edge, String cryptaId) {
        this.edge = edge;
        this.setCryptaId(cryptaId);
    }

    public EdgeInComponent(ru.yandex.crypta.graph2.model.matching.proto.EdgeInComponent proto) {
        this.edge = new Edge(
                proto.getId1(),
                Soup.CONFIG.getIdType(proto.getId1Type()).getType(),
                proto.getId2(),
                Soup.CONFIG.getIdType(proto.getId2Type()).getType(),
                Soup.CONFIG.getSourceType(proto.getSourceType()).getType(),
                Soup.CONFIG.getLogSource(proto.getLogSource()).getType(),
                Cf.list(),
                Option.of(proto.getDatesWeight()),
                Option.of(proto.getSurvivalWeight()));

        this.setCryptaId(proto.getCryptaId());
        this.setMergeKey(new MergeKey(
                proto.getMergeKey(),
                proto.getMergeKeyType()
        ));
    }

    public Edge getEdge() {
        return edge;
    }

    public MergeKey getMergeKey() {
        return mergeKey;
    }

    public void setMergeKey(MergeKey mergeKey) {
        this.mergeKey = mergeKey;
    }

    public String getCryptaId() {
        return cryptaId;
    }

    public void setCryptaId(String cryptaIdStr) {
        this.cryptaId = cryptaIdStr;
    }

    public EdgeInComponent withCryptaId(String componentId) {
        setCryptaId(componentId);
        return this;
    }

    public EdgeInComponent copyWithCryptaId(String newCryptaId) {
        return new EdgeInComponent(this.edge, newCryptaId);
    }

    public static EdgeInComponent fromEdge(Edge edge, String cryptaId) {
        return new EdgeInComponent(edge, cryptaId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgeInComponent that)) {
            return false;
        }

        if (!edge.equals(that.edge)) {
            return false;
        }
        return cryptaId.equals(that.cryptaId);
    }

    @Override
    public int hashCode() {
        int result = edge.hashCode();
        result = 31 * result + cryptaId.hashCode();
        return result;
    }
}
