package ru.yandex.crypta.graph2.model.matching.edge;

import java.util.Comparator;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.model.soup.edge.EdgeProtoHelper;
import ru.yandex.crypta.graph2.model.soup.edge.weight.EdgeInfoProvider;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;

/**
 * TODO: seems currently not used, MergeOfferPriority is used instead
 */
public class EdgePriority implements YtSerializable {

    private EdgeInfoProvider edgeInfoProvider;
    private Comparator<Edge> edgeComparator;
    private Comparator<CollectionF<Edge>> multiEdgeComparator;


    public EdgePriority(EdgeInfoProvider edgeInfoProvider) {
        this.edgeInfoProvider = edgeInfoProvider;
    }

    public Comparator<Edge> getEdgeComparator() {
        if (edgeComparator == null) {
            // creating it ad-hoc at yt side to avoid serialization issues
            edgeComparator = Comparator
                    .<Edge>comparingInt(e -> edgeInfoProvider.getEdgeTypeStrength(e).getNumber())
                    .thenComparingDouble(e -> edgeInfoProvider.getEdgeWeight(e))
                    .thenComparing(Edge::getId1) // adds some determinism when weight is equal
                    .thenComparing(Edge::getId2); // adds some determinism when weight is equal
        }
        return edgeComparator;

    }

    public Comparator<CollectionF<Edge>> getMultiEdgeComparator() {
        if (multiEdgeComparator == null) {
            // creating it ad-hoc at yt side to avoid serialization issues
            multiEdgeComparator = Comparator
                    .comparing(edgeInfoProvider::getMaxEdgeTypeStrength, EdgeProtoHelper.EDGE_STRENGTH_COMPARATOR)
                    .thenComparingDouble(edges -> edgeInfoProvider.getMultiEdgeWeight(edges));
        }
        return multiEdgeComparator;

    }

    public ListF<Edge> sortEdgesByActivityDesc(CollectionF<Edge> edges) {
        return edges.sorted(getEdgeComparator().reversed());
    }

    public ListF<Edge> sortEdgesByActivityAsc(CollectionF<Edge> edges) {
        return edges.sorted(getEdgeComparator());
    }

    public Option<Edge> getMin(CollectionF<Edge> edges) {
        return edges.minO(getEdgeComparator());
    }

    public EdgeInfoProvider getEdgeInfoProvider() {
        return edgeInfoProvider;
    }
}
