package ru.yandex.crypta.graph2.model.matching.graph;

import java.io.Serializable;

import org.jgrapht.WeightedGraph;
import org.jgrapht.graph.Multigraph;
import org.jgrapht.graph.WeightedMultigraph;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.model.soup.edge.weight.EdgeInfoProvider;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;

public class JGraphTUtils {

    public static CustomWeightedGraph toWeightedGraph(CollectionF<Edge> edges, CollectionF<Vertex> vertices,
                                                      EdgeInfoProvider edgeInfoProvider) {
        return new CustomWeightedGraph(edges, vertices, edgeInfoProvider);
    }

    public static CustomWeightedGraph toWeightedGraph(Component component,
                                                      EdgeInfoProvider edgeInfoProvider) {
        return new CustomWeightedGraph(component.getInnerEdges(), component.getVertices(), edgeInfoProvider);
    }


    public static Multigraph<Vertex, Edge> toGraph(CollectionF<Edge> edges, CollectionF<Vertex> vertices) {
        Multigraph<Vertex, Edge> graph = toGraph(edges);

        // in case of single vertices
        for (Vertex vertex : vertices) {
            graph.addVertex(vertex);
        }

        return graph;
    }

    public static Multigraph<Vertex, Edge> toGraph(CollectionF<Edge> edges) {
        Multigraph<Vertex, Edge> graph = new Multigraph<>(Edge.class);

        for (Edge edge : edges) {
            Vertex v1 = edge.getVertex1();
            Vertex v2 = edge.getVertex2();
            graph.addVertex(v1);
            graph.addVertex(v2);
            if (!v1.equals(v2)) {
                graph.addEdge(v1, v2, edge);
            }
        }
        return graph;
    }

    public static Multigraph<Vertex, Edge> toGraph(Component component) {
        return toGraph(component.getInnerEdges(), component.getVertices());
    }

    public static class CustomWeightedGraph
            extends WeightedMultigraph<Vertex, Edge>
            implements Serializable, WeightedGraph<Vertex, Edge> {

        private final EdgeInfoProvider edgeInfoProvider;

        public CustomWeightedGraph(CollectionF<Edge> edges, CollectionF<Vertex> vertices, EdgeInfoProvider edgeInfoProvider) {
            super(Edge.class);
            this.edgeInfoProvider = edgeInfoProvider;

            for (Vertex vertex : vertices) {
                this.addVertex(vertex);
            }

            for (Edge edge : edges) {
                Vertex v1 = edge.getVertex1();
                Vertex v2 = edge.getVertex2();
                this.addVertex(v1);
                this.addVertex(v2);
                this.addEdge(v1, v2, edge);
            }

        }

        @Override
        public void setEdgeWeight(Edge e, double weight) {
        }

        @Override
        public double getEdgeWeight(Edge e) {
            return edgeInfoProvider.getEdgeWeight(e);
        }
    }


}
