package ru.yandex.crypta.graph2.model.matching.graph.cryptaid;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.ComponentCenter;
import ru.yandex.crypta.graph2.model.matching.component.ComponentCenterWithWeight;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.soup.edge.weight.EdgeInfoProvider;
import ru.yandex.crypta.graph2.model.soup.vertex.weight.VerticesWeightsProvider;

public class CryptaIdDispenserByNeighboursWeight implements CryptaIdDispenser {

    private final EdgeInfoProvider edgeInfoProvider;

    public CryptaIdDispenserByNeighboursWeight(EdgeInfoProvider edgeInfoProvider) {
        this.edgeInfoProvider = edgeInfoProvider;
    }

    @Override
    public Option<ComponentCenter> getCryptaId(Component component, GraphInfo graphInfo) {

        VerticesWeightsProvider verticesWeightsProvider = new VerticesWeightsProvider(
                edgeInfoProvider,
                component.getInnerEdges(),
                component.getVertices()
        );

        ListF<ComponentCenterWithWeight> candidates = component.getVertices().map(v ->
                new ComponentCenterWithWeight(ComponentCenter.fromVertex(v), verticesWeightsProvider.getVertexWeight(v))
        );

        return candidates.maxO(ComponentCenterWithWeight.BY_CC_WEIGHT)
                .map(ComponentCenterWithWeight::getComponentCenter);

    }
}
