package ru.yandex.crypta.graph2.model.matching.graph.cryptaid;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.ComponentCenter;
import ru.yandex.crypta.graph2.model.matching.component.ComponentCenterWithWeight;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.model.soup.edge.EdgeType;
import ru.yandex.crypta.graph2.model.soup.edge.weight.EdgeInfoProvider;
import ru.yandex.crypta.graph2.model.soup.props.Login;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.graph2.model.soup.vertex.weight.VerticesWeightsProvider;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;

import static ru.yandex.crypta.graph.soup.config.proto.ELogSourceType.PASSPORT_DICT;
import static ru.yandex.crypta.graph.soup.config.proto.ESourceType.PASSPORT_PROFILE;
import static ru.yandex.crypta.lib.proto.identifiers.EIdType.LOGIN;
import static ru.yandex.crypta.lib.proto.identifiers.EIdType.PUID;

public class CryptaIdDispenserWithPuidPriority implements CryptaIdDispenser {

    public static final EdgeType PUID_LOGIN_EDGE_TYPE = new EdgeType(PUID, LOGIN, PASSPORT_PROFILE, PASSPORT_DICT);

    private final EdgeInfoProvider edgeInfoProvider;
    private CryptaIdDispenser defaultCryptaIdDispenser;

    public CryptaIdDispenserWithPuidPriority(EdgeInfoProvider edgeInfoProvider,
                                             CryptaIdDispenser defaultCryptaIdDispenser) {
        this.edgeInfoProvider = edgeInfoProvider;
        this.defaultCryptaIdDispenser = defaultCryptaIdDispenser;
    }

    @Override
    public Option<ComponentCenter> getCryptaId(Component component, GraphInfo graphInfo) {

        VerticesWeightsProvider verticesWeightsProvider = new VerticesWeightsProvider(
                edgeInfoProvider,
                component.getInnerEdges(),
                component.getVertices()
        );

        CollectionF<ComponentCenterWithWeight> puidCandidates = getActivePuids(component, graphInfo).map(v ->
                new ComponentCenterWithWeight(ComponentCenter.fromVertex(v), verticesWeightsProvider.getVertexWeight(v))
        );

        if (puidCandidates.isNotEmpty()) {
            ComponentCenterWithWeight max = puidCandidates.max(ComponentCenterWithWeight.BY_CC_WEIGHT);
            return Option.of(max.getComponentCenter());
        } else {
            return defaultCryptaIdDispenser.getCryptaId(component, graphInfo);
        }

    }

    private CollectionF<Vertex> getActivePuids(Component component, GraphInfo graphInfo) {

        SetF<String> usualPuids = getUsualPuids(component);

        return component.getInnerEdges().filterMap(e -> {
            Vertex yandexuid;
            Vertex puid;
            if (e.getId1Type() == EIdType.PUID && e.getId2Type() == EIdType.YANDEXUID) {
                puid = e.getVertex1();
                yandexuid = e.getVertex2();
            } else if (e.getId2Type() == EIdType.PUID && e.getId1Type() == EIdType.YANDEXUID) {
                puid = e.getVertex2();
                yandexuid = e.getVertex1();
            } else {
                return Option.empty();
            }

            if (usualPuids.containsTs(puid.getId()) && graphInfo.verticesProperties.isActive(yandexuid)) {
                return Option.of(puid);
            } else {
                return Option.empty();
            }

        });

    }


    private SetF<String> getUsualPuids(Component component) {
        return component.getInnerEdges()
                .filter(e ->
                        e.calculateEdgeType().equals(PUID_LOGIN_EDGE_TYPE) &&
                                !Login.isSyntheticLogin(e.getId2())
                ).map(Edge::getId1).unique();

    }
}
