package ru.yandex.crypta.graph2.model.matching.merge;

import java.util.Collection;

import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject
public class MergeKeyWithNewCryptaIds {

    @YTreeField
    private String cryptaId;

    @YTreeField
    @YTreeFlattenField
    private MergeKey mergeKey;  //  ~ MergeKey.betweenComponents(leftCryptaId, rightCryptaId)

    @YTreeField
    private String leftCryptaId;

    @YTreeField
    private String rightCryptaId;

    @YTreeField
    private String newLeftCryptaId;

    @YTreeField
    private String newRightCryptaId;


    public MergeKeyWithNewCryptaIds(MergeKey mergeKey, String cryptaId) {
        this.mergeKey = mergeKey;
        this.cryptaId = cryptaId;
        var cryptaIds = mergeKey.extractCryptaIds();
        this.leftCryptaId = cryptaIds.leftCryptaId;
        this.rightCryptaId = cryptaIds.rightCryptaId;

        // the same cryptaids by default
        this.newLeftCryptaId = leftCryptaId;
        this.newRightCryptaId = rightCryptaId;
    }

    public void setCryptaId(String cryptaId) {
        this.cryptaId = cryptaId;
    }

    public void setNewLeftCryptaId(String cryptaId) {
        this.newLeftCryptaId = cryptaId;
    }

    public void setNewRightCryptaId(String cryptaId) {
        this.newRightCryptaId = cryptaId;
    }

    public MergeKey getMergeKey() {
        return mergeKey;
    }

    public String getCryptaId() {
        return cryptaId;
    }

    public String getLeftCryptaId() {
        return leftCryptaId;
    }

    public String getRightCryptaId() {
        return rightCryptaId;
    }

    public String getNewLeftCryptaId() {
        return newLeftCryptaId;
    }

    public String getNewRightCryptaId() {
        return newRightCryptaId;
    }

    public MergeKeyWithNewCryptaIds updateFromTo(String fromCryptaId, String toCryptaId) {
        if (leftCryptaId.equals(fromCryptaId)) {
            this.newLeftCryptaId = toCryptaId;
        }
        if (rightCryptaId.equals(fromCryptaId)) {
            this.newRightCryptaId = toCryptaId;
        }
        return this;
    }

    public MergeKeyWithNewCryptaIds updateWithOtherMergeKeys(Collection<MergeKeyWithNewCryptaIds> mergeKeys) {
        for (MergeKeyWithNewCryptaIds mk : mergeKeys) {
            if (!mk.getLeftCryptaId().equals(mk.getNewLeftCryptaId())) {
                updateFromTo(mk.getLeftCryptaId(), mk.getNewLeftCryptaId());
            }
            if (!mk.getRightCryptaId().equals(mk.getNewRightCryptaId())) {
                updateFromTo(mk.getRightCryptaId(), mk.getNewRightCryptaId());
            }
        }
        return this;
    }
}
