package ru.yandex.crypta.graph2.model.matching.merge;

import ru.yandex.crypta.graph.soup.config.proto.TEdgeProps;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

/**
 * Offer for component to merge by key
 */
@YTreeObject
public class MergeNeighbour {

    @YTreeField
    private String cryptaId;

    @YTreeField
    @YTreeFlattenField
    private MergeKey neighbourKey;

    @YTreeField
    private TEdgeProps.EEdgeStrength mergeStrength = TEdgeProps.EEdgeStrength.UNKNOWN;

    public MergeNeighbour(String cryptaId, MergeKey neighbourKey) {
        this.cryptaId = cryptaId;
        this.neighbourKey = neighbourKey;
    }

    public String getCryptaId() {
        return cryptaId;
    }

    public MergeKey getNeighbourKey() {
        return neighbourKey;
    }

    public TEdgeProps.EEdgeStrength getMergeStrength() {
        return mergeStrength;
    }

    public void setMergeStrength(TEdgeProps.EEdgeStrength mergeStrength) {
        this.mergeStrength = mergeStrength;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MergeNeighbour mergeNeighbour)) {
            return false;
        }

        if (!cryptaId.equals(mergeNeighbour.cryptaId)) {
            return false;
        }
        return neighbourKey.equals(mergeNeighbour.neighbourKey);
    }

    @Override
    public int hashCode() {
        int result = cryptaId.hashCode();
        result = 31 * result + neighbourKey.hashCode();
        return result;
    }
}
