package ru.yandex.crypta.graph2.model.matching.merge;

import java.util.Comparator;

public enum MergeOfferStatus {
    INIT(true),
    INIT_TRUSTED(true),
    FAILED_BY_SCORE(false),
    FAILED_BY_SIMILARITY(false),
    DECISION_LEADER(true),
    DECISION_FOLLOWER(true),
    DECISION_REJECTED(false),
    CONFIRMED(true),
    NOT_CONFIRMED(false),
    SPLIT(true),
    SPLIT_BY_VERTEX(true);

    public static final Comparator<MergeOfferStatus> BY_STATUS = Comparator
            .comparing(MergeOfferStatus::isSuccess);

    private final boolean isSuccess;

    MergeOfferStatus(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public boolean isSuccess() {
        return isSuccess;
    }
}
